
########## Tcl recorder starts at 03/19/09 14:51:48 ##########

set version "7.2"
set proj_dir "C:/test/MachXOvga"
cd $proj_dir

# Get directory paths
set pver $version
regsub -all {\.} $pver {_} pver
set lscfile "lsc_"
append lscfile $pver ".ini"
set lsvini_dir [lindex [array get env LSC_INI_PATH] 1]
set lsvini_path [file join $lsvini_dir $lscfile]
if {[catch {set fid [open $lsvini_path]} msg]} {
	 puts "File Open Error: $lsvini_path"
	 return false
} else {set data [read $fid]; close $fid }
foreach line [split $data '\n'] { 
	set lline [string tolower $line]
	set lline [string trim $lline]
	if {[string compare $lline "\[paths\]"] == 0} { set path 1; continue}
	if {$path && [regexp {^\[} $lline]} {set path 0; break}
	if {$path && [regexp {^bin} $lline]} {set cpld_bin $line; continue}
	if {$path && [regexp {^fpgapath} $lline]} {set fpga_dir $line; continue}
	if {$path && [regexp {^fpgabinpath} $lline]} {set fpga_bin $line}}

set cpld_bin [string range $cpld_bin [expr [string first "=" $cpld_bin]+1] end]
regsub -all "\"" $cpld_bin "" cpld_bin
set cpld_bin [file join $cpld_bin]
set install_dir [string range $cpld_bin 0 [expr [string first "ispcpld" $cpld_bin]-2]]
regsub -all "\"" $install_dir "" install_dir
set install_dir [file join $install_dir]
set fpga_dir [string range $fpga_dir [expr [string first "=" $fpga_dir]+1] end]
regsub -all "\"" $fpga_dir "" fpga_dir
set fpga_dir [file join $fpga_dir]
set fpga_bin [string range $fpga_bin [expr [string first "=" $fpga_bin]+1] end]
regsub -all "\"" $fpga_bin "" fpga_bin
set fpga_bin [file join $fpga_bin]

if {[string match "*$fpga_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$fpga_bin;$env(PATH)" }

if {[string match "*$cpld_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$cpld_bin;$env(PATH)" }

lappend auto_path [file join $install_dir "ispcpld" "tcltk" "lib" "ispwidget" "runproc"]
package require runcmd

# Commands to make the Process: 
# JEDEC File
if [catch {open vga.cmd w} rspFile] {
	puts stderr "Cannot create response file vga.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: machxovga.sty
PROJECT: vga
WORKING_PATH: \"$proj_dir\"
MODULE: vga
VERILOG_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/verilog/machxo.v\" MachXOvga.h vga.v
OUTPUT_FILE_NAME: vga
SUFFIX_NAME: edi
WRITE_PRF: false
Vlog_std_v2001: V2001
FREQUENCY:  200
FREQUENCY: 1
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -3
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:  3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:  0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DUP: false
fixgatedclocks:  3
fixgeneratedclocks:  3
DEFAULT_ENUM_ENCODING: default
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -rem -e vga -target MACHXO -part LCMXO256C -pro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete vga.cmd
if [runCmd "\"$fpga_bin/edif2ngd\" -l MachXO -d LCMXO256C \"vga.edi\" \"vga.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"machxovga.tcy\" -w \"vga.ngo\" -m \"vga.ngo\" \"machxovga.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a MachXO -d LCMXO256C -p \"$fpga_dir/mj5g00/data\" -p \"$fpga_dir/mj5g00e/data\" \"vga.ngo\" \"machxovga.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a MachXO -p LCMXO256C -t TQFP100 -s 3 \"machxovga.ngd\" -o \"machxovga_map.ncd\" -mp \"machxovga.mrp\" \"machxovga.lpf\" -c 0"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.mt
-to machxovga.tw1
-o machxovga.tcm
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"machxovga.cmm\" -f \"machxovga.cm2\" -arch MachXO \"machxovga_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.p2t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=0
-exp parCDR=0
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=ON
"
	close $rspFile
}
if [catch {open machxovga.p3t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log machxovga.log
-o machxovga_mp.par
-pr machxovga.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p machxovga.p2t -f \"machxovga.p3t\" \"machxovga_map.ncd\" \"machxovga.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.pt
-to machxovga.twr
-o machxovga.tcp
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"machxovga.cmp\" -f \"machxovga.cm2\" -arch MachXO \"machxovga.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 14:51:48 ###########


########## Tcl recorder starts at 03/19/09 14:56:58 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open vga.cmd w} rspFile] {
	puts stderr "Cannot create response file vga.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: machxovga.sty
PROJECT: vga
WORKING_PATH: \"$proj_dir\"
MODULE: vga
VERILOG_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/verilog/machxo.v\" MachXOvga.h vga.v
OUTPUT_FILE_NAME: vga
SUFFIX_NAME: edi
WRITE_PRF: false
Vlog_std_v2001: V2001
FREQUENCY:  200
FREQUENCY: 1
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -3
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:  3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:  0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DUP: false
fixgatedclocks:  3
fixgeneratedclocks:  3
DEFAULT_ENUM_ENCODING: default
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -rem -e vga -target MACHXO -part LCMXO256C -pro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete vga.cmd
if [runCmd "\"$fpga_bin/edif2ngd\" -l MachXO -d LCMXO256C \"vga.edi\" \"vga.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"machxovga.tcy\" -w \"vga.ngo\" -m \"vga.ngo\" \"machxovga.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a MachXO -d LCMXO256C -p \"$fpga_dir/mj5g00/data\" -p \"$fpga_dir/mj5g00e/data\" \"vga.ngo\" \"machxovga.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a MachXO -p LCMXO256C -t TQFP100 -s 3 \"machxovga.ngd\" -o \"machxovga_map.ncd\" -mp \"machxovga.mrp\" \"machxovga.lpf\" -c 0"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.mt
-to machxovga.tw1
-o machxovga.tcm
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"machxovga.cmm\" -f \"machxovga.cm2\" -arch MachXO \"machxovga_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.p2t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=0
-exp parCDR=0
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=ON
"
	close $rspFile
}
if [catch {open machxovga.p3t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log machxovga.log
-o machxovga_mp.par
-pr machxovga.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p machxovga.p2t -f \"machxovga.p3t\" \"machxovga_map.ncd\" \"machxovga.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.pt
-to machxovga.twr
-o machxovga.tcp
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"machxovga.cmp\" -f \"machxovga.cm2\" -arch MachXO \"machxovga.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 14:56:58 ###########


########## Tcl recorder starts at 03/19/09 15:01:11 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open vga.cmd w} rspFile] {
	puts stderr "Cannot create response file vga.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: machxovga.sty
PROJECT: vga
WORKING_PATH: \"$proj_dir\"
MODULE: vga
VERILOG_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/verilog/machxo.v\" MachXOvga.h vga.v
OUTPUT_FILE_NAME: vga
SUFFIX_NAME: edi
WRITE_PRF: false
Vlog_std_v2001: V2001
FREQUENCY:  200
FREQUENCY: 1
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -3
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:  3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:  0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DUP: false
fixgatedclocks:  3
fixgeneratedclocks:  3
DEFAULT_ENUM_ENCODING: default
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -rem -e vga -target MACHXO -part LCMXO256C -pro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete vga.cmd
if [runCmd "\"$fpga_bin/edif2ngd\" -l MachXO -d LCMXO256C \"vga.edi\" \"vga.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"machxovga.tcy\" -w \"vga.ngo\" -m \"vga.ngo\" \"machxovga.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a MachXO -d LCMXO256C -p \"$fpga_dir/mj5g00/data\" -p \"$fpga_dir/mj5g00e/data\" \"vga.ngo\" \"machxovga.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a MachXO -p LCMXO256C -t TQFP100 -s 3 \"machxovga.ngd\" -o \"machxovga_map.ncd\" -mp \"machxovga.mrp\" \"machxovga.lpf\" -c 0"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.mt
-to machxovga.tw1
-o machxovga.tcm
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"machxovga.cmm\" -f \"machxovga.cm2\" -arch MachXO \"machxovga_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.p2t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=0
-exp parCDR=0
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=ON
"
	close $rspFile
}
if [catch {open machxovga.p3t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log machxovga.log
-o machxovga_mp.par
-pr machxovga.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p machxovga.p2t -f \"machxovga.p3t\" \"machxovga_map.ncd\" \"machxovga.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.pt
-to machxovga.twr
-o machxovga.tcp
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"machxovga.cmp\" -f \"machxovga.cm2\" -arch MachXO \"machxovga.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 15:01:11 ###########


########## Tcl recorder starts at 03/19/09 17:47:45 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open vga.cmd w} rspFile] {
	puts stderr "Cannot create response file vga.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: machxovga.sty
PROJECT: vga
WORKING_PATH: \"$proj_dir\"
MODULE: vga
VERILOG_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/verilog/machxo.v\" MachXOvga.h vga.v
OUTPUT_FILE_NAME: vga
SUFFIX_NAME: edi
WRITE_PRF: false
Vlog_std_v2001: V2001
FREQUENCY:  200
FREQUENCY: 1
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -3
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:  3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:  0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DUP: false
fixgatedclocks:  3
fixgeneratedclocks:  3
DEFAULT_ENUM_ENCODING: default
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -rem -e vga -target MACHXO -part LCMXO256C -pro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete vga.cmd
if [runCmd "\"$fpga_bin/edif2ngd\" -l MachXO -d LCMXO256C \"vga.edi\" \"vga.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"machxovga.tcy\" -w \"vga.ngo\" -m \"vga.ngo\" \"machxovga.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a MachXO -d LCMXO256C -p \"$fpga_dir/mj5g00/data\" -p \"$fpga_dir/mj5g00e/data\" \"vga.ngo\" \"machxovga.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a MachXO -p LCMXO256C -t TQFP100 -s 3 \"machxovga.ngd\" -o \"machxovga_map.ncd\" -mp \"machxovga.mrp\" \"machxovga.lpf\" -c 0"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.mt
-to machxovga.tw1
-o machxovga.tcm
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"machxovga.cmm\" -f \"machxovga.cm2\" -arch MachXO \"machxovga_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.p2t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=0
-exp parCDR=0
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=ON
"
	close $rspFile
}
if [catch {open machxovga.p3t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log machxovga.log
-o machxovga_mp.par
-pr machxovga.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p machxovga.p2t -f \"machxovga.p3t\" \"machxovga_map.ncd\" \"machxovga.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.pt
-to machxovga.twr
-o machxovga.tcp
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"machxovga.cmp\" -f \"machxovga.cm2\" -arch MachXO \"machxovga.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 17:47:45 ###########


########## Tcl recorder starts at 03/19/09 17:49:50 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open vga.cmd w} rspFile] {
	puts stderr "Cannot create response file vga.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: machxovga.sty
PROJECT: vga
WORKING_PATH: \"$proj_dir\"
MODULE: vga
VERILOG_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/verilog/machxo.v\" MachXOvga.h vga.v
OUTPUT_FILE_NAME: vga
SUFFIX_NAME: edi
WRITE_PRF: false
Vlog_std_v2001: V2001
FREQUENCY:  200
FREQUENCY: 1
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -3
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:  3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:  0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DUP: false
fixgatedclocks:  3
fixgeneratedclocks:  3
DEFAULT_ENUM_ENCODING: default
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -rem -e vga -target MACHXO -part LCMXO256C -pro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete vga.cmd
if [runCmd "\"$fpga_bin/edif2ngd\" -l MachXO -d LCMXO256C \"vga.edi\" \"vga.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"machxovga.tcy\" -w \"vga.ngo\" -m \"vga.ngo\" \"machxovga.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a MachXO -d LCMXO256C -p \"$fpga_dir/mj5g00/data\" -p \"$fpga_dir/mj5g00e/data\" \"vga.ngo\" \"machxovga.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a MachXO -p LCMXO256C -t TQFP100 -s 3 \"machxovga.ngd\" -o \"machxovga_map.ncd\" -mp \"machxovga.mrp\" \"machxovga.lpf\" -c 0"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.mt
-to machxovga.tw1
-o machxovga.tcm
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"machxovga.cmm\" -f \"machxovga.cm2\" -arch MachXO \"machxovga_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.p2t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=0
-exp parCDR=0
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=ON
"
	close $rspFile
}
if [catch {open machxovga.p3t w} rspFile] {
	puts stderr "Cannot create response file machxovga.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log machxovga.log
-o machxovga_mp.par
-pr machxovga.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p machxovga.p2t -f \"machxovga.p3t\" \"machxovga_map.ncd\" \"machxovga.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open machxovga.cm2 w} rspFile] {
	puts stderr "Cannot create response file machxovga.cm2: $rspFile"
} else {
	puts $rspFile "-t machxovga.pt
-to machxovga.twr
-o machxovga.tcp
-log machxovga.log
-pr machxovga.prf
-rpt machxovga.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"machxovga.cmp\" -f \"machxovga.cm2\" -arch MachXO \"machxovga.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete machxovga.cm2
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 17:49:50 ###########


########## Tcl recorder starts at 03/19/09 17:54:21 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open machxovga.t2b w} rspFile] {
	puts stderr "Cannot create response file machxovga.t2b: $rspFile"
} else {
	puts $rspFile "-g ES:No
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"machxovga.t2b\" -w \"machxovga.ncd\" \"machxovga.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$cpld_bin/ispdfw\" -prj machxovga -if machxovga.bit -log machxovga.prm -b2j -optoft -jed -of machxovga.jed -comment machxovga.alt "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 03/19/09 17:54:21 ###########

